/* PStrUtilities.c
 *
 * CopyPStrings and ConcatPStrings - "borrowed" from the TBUtilities.cp
 * part of TCL.
 *
 */

#include "PStrUtilities.h"

#define Min(x,y) ((x) < (y) ? (x) : (y))

/******************************************************************************
 PConcatStrings
 
		Concatenate two Pascal strings by attaching the second string on
		the end of the first string.
 ******************************************************************************/

void	PConcatStrings(
	Str255		first,
	ConstStr255Param second)
{
    
    short charsToCopy;
    
    /* Truncate if concatenated string would be longer than 255 chars.  */
    
    charsToCopy = Min(second[0], 255 - first[0]);
    BlockMove(second + 1, first + first[0] + 1, (long) charsToCopy);
    first[0] += charsToCopy;
}